



/******************************************************************************************************
 **                                                                                                  **
 **                               Ex- Test Module Sensor MH-Z14A CO2                                 **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : AVR Mega2560 (Board ET- MEGA2560 ADK)                                      **
 **                     : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.8.5                                                              **
 **                                                                                                  **                   
 **   Port Interface    :     PIN Arduino Board                          MH-Z14A CO2                 **
 **                         --------------------                        --------------               **
 **                         A0                      Connect      Pin-4 :Analog Output Mode           **
 **                         D9                                   Pin-6 :PWM Output Mode              **                
 **                                                                                                  **
 **  Solfware Serial    :   D10-Rx                 Connect       Pin-19(Tx):Digital Output Mode      **   
 **                         D11-Tx                 Connect       Pin-18(Rx):Digital output Mode      **                                                  
 **                         Set BR=9600                                                              **
 **                                                                                                  **                                                                                                 **  Solftware Serial   :   D10-Rx                 Connect       Pin-19(Tx):Digital Output Mode      **   
 **  Hardware Serial0   :  D0-Rx0                 Connect       Monitor RS232 PC                     **   
 **                        D1-Tx0                 Connect       Monitor Rs232 PC                     **                                 
 **                         Set BR=9600                                                              **
 **                                                                                                  **
 **  Operation          : Read Value CO2 from 3 Output Sensor(Analog,PWM,Digital) Then Sent value    **
 **                       ppm to RS232 for Monitor                                                   **
 **                                                                                                  **                       
 **  Create By          :   Mr.Sittiphol Yooyod (WWW.ETT.CO.TH)                                      **
 **  Last Update        :   25/May/2019                                                              ** 
 ******************************************************************************************************/


#include <SoftwareSerial.h>

const int analogPin = A0 ;  //Use read Analog
const int pwmPin    = 9  ;  //Use read PWM

const long samplePeriod = 3000L;    //Loop delay Time 3 sec

SoftwareSerial sensor(10, 11); // RX, TX

//HardwareSerial &sensor = Serial1;


const byte Cmd_ReadCO2[]       = {0xFF, 0x01, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79};  //Command Read Value Co2 PPM
const byte Cmd_CaliZero[]      = {0xFF, 0x01, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78};  //Command Calibrate Zero
const byte Cmd_Stop_AutoCali[] = {0xFF, 0x01, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86};  //Command Stop Auto Calibrate Zero


byte result[9];  //keep Data from CO2 after Sent data to Sensor
long lastSampleTime = 0;


//*******************--- Setup ---************************

void setup() 
{
   Serial.begin(9600);  //Set Serial0(Rx0:D0,Tx0:D1) BR=9600 for Sent Value CO2(ppm) 3 Output to RS232 Monitor
   sensor.begin(9600);
   pinMode(pwmPin, INPUT_PULLUP);
}


//***************---- Main Program ----********************

void loop() 
{
  long now = millis();
  int CO2ppm_Analog ,CO2ppm_PWM,CO2ppm_Digital   ;
 
  
  if(now > lastSampleTime + samplePeriod) //Loop read CO2 Every 3 Sec(3000ms)
   {
     lastSampleTime      = now                 ;  //Update New time loop
     CO2ppm_Analog       = readPPM_ADC()       ;  //Read Co2 form Pin Analog Out
     CO2ppm_PWM          = readPPM_PWM()       ;  //Read Co2 form Pin PWM Out
     CO2ppm_Digital      = readPPMSerial()     ;  //Read Co2 form Pin Rx,Tx
    
 
     Serial.print("\n CO2-ppm(Analog) = ")       ;  //Sent Value CO2-ppm of pin Analog-Out to RS232
     Serial.print(CO2ppm_Analog)                 ; 
      
     Serial.print("\n CO2-ppm(PWM) = ")          ;  //Sent Value CO2-ppm of pin PWM-Out to RS232
     Serial.print(CO2ppm_PWM)                    ; 

     Serial.print("\n CO2-ppm(Digital) = ")      ;  //Sent Value CO2-ppm of Pin Rx,Tx to RS232
     Serial.print(CO2ppm_Digital)                ;  
 
   
     Serial.print("\n") ;
  
   }
}

//********************* ---- Sub-Program --- *********************

//.........................................................................
//..             Function: Read CO2-Analog from Pin Analog-OUT           ..
//.........................................................................

int readPPM_ADC() 
{
  float v = analogRead(analogPin) * 5.0 / 1023.0 ; //Read ADC and Convert to Voltage
  int ppm = int((v - 0.4) * 3125.0)              ; //Calculate CO2 Voltage to ppm unit
  return ppm;
}

//...............................................................................
//..                Function: Read CO2-PWM from Pin PWM-OUT                    ..
//..                                                                           ..
//..          t0 = keep time Start pluse High                                  ..
//..          t1 = keep time end pluse High(or time Start Pluse Low)           ..
//..          t2 = keep time Start pluse high round2(or time End Pluse Low)    ..
//..          th = keep time Time for Pluse high level                         ..
//..          tl = keep time Time for Pluse low level                          ..
//...............................................................................

int readPPM_PWM() 
{
  int ppm ;
  
  while (digitalRead(pwmPin) == LOW) {}  ; //wait for pulse to go high
  long t0 = millis()                     ; //Keep Time begin pulse High
  
  while (digitalRead(pwmPin) == HIGH) {} ; //wait for pulse to go low
  long t1 = millis()                     ; //Keep Time end pulse High
  
  while (digitalRead(pwmPin) == LOW) {}  ; //wait for pulse to go high again
  long t2 = millis()                     ; //Keep Time begin pulse High cycle2
  
  long th = t1-t0                        ; //Calculate Time for pluse high level
  long tl = t2-t1                        ; //Calculate Time for pluse high level

   ppm = 5000L * (th - 2) / (th + tl - 4); //Calculate Value CO2 ppm unit
  
  while (digitalRead(pwmPin) == HIGH) {} ; //wait for pulse to go low
  delay(10);                               //allow output to settle.
 
  return  ppm ;

}



//................................................................................................
//..                 Function: Read CO2-Digital from Pin Rx,Tx (Serial-Uart BR=9600)            ..
//................................................................................................


int readPPMSerial() 
 {
   for (int i = 0; i < 9; i++) 
   {
     sensor.write(Cmd_ReadCO2[i]);  //Sent Command Read CO2
   }

   while (sensor.available() < 9) {}; // wait for response
   for(int i = 0; i < 9; i++)
    {
      result[i] = sensor.read();      //Read data from Sensor
    }

   //---------- Calculate Check-Sum Data (CRC) ------------
   
   byte crc = 0;  int byt        ;
   for (byt = 1 ; byt < 8;byt++) 
    {
      crc += result[byt]        ;  //Add data Respond   Byte1 to byte7
    }
   crc = 255 - crc              ;  //Invert crc
   crc++                        ;  //crc+1
   if(result [8] != crc)           //Check crc From Value cal with Value Response
    { 
      return 0 ;  
    }                              // data error exit function  if data true next line
  //--------------------------------------------------------
   
   int high = result[2];
   int low = result[3];
   
   return high * 256 + low  ;   // Total Data Byte High-Low then returen Value PPM
}


//................................................................................................
//..         Function: Sent Command  Calibrate Zero to Sensor  (Serial-Uart BR=9600)            ..
//................................................................................................

void CalibrateZero()
 {
  for (int i = 0; i < 9; i++) 
   {
     sensor.write(Cmd_CaliZero[i]);  //Sent Command Calibrate Zero
   }
 }

//................................................................................................
//..         Function: Sent Command  Calibrate Zero to Sensor  (Serial-Uart BR=9600)            ..
//................................................................................................ 

 void Stop_AutoCali()
 {
  for (int i = 0; i < 9; i++) 
   {
     sensor.write(Cmd_Stop_AutoCali[i]);  //Sent Command Stop Auto Calibrate Zero
   }
 }



